<?php
/*
 Plugin Name: 图片粘贴上传
 Plugin URI: http://www.zingiri.com
 Description: 图片粘贴上传插件可以让你在WordPress编辑器里面直接粘贴上传文件
 Author: Zingiri
 Version: 3.0.2
 Author URI: http://www.zingiri.com/
 */

if (!defined("IMAGEPASTE_PLUGIN")) {
	$imagepaste_plugin=str_replace(realpath(dirname(__FILE__).'/..'),"",dirname(__FILE__));
	$imagepaste_plugin=substr($imagepaste_plugin,1);
	define("IMAGEPASTE_PLUGIN", $imagepaste_plugin);
}
if (file_exists(dirname(__FILE__).'/source.inc.php')) require(dirname(__FILE__).'/source.inc.php');
define("IMAGEPASTE_URL", WP_CONTENT_URL . "/plugins/".IMAGEPASTE_PLUGIN."/");
if (!defined("IMAGEPASTE_JSDIR")) define("IMAGEPASTE_JSDIR","");

add_action("init","imagepaste_init");
add_action('admin_head','imagepaste_admin_header');

function imagepaste_admin_header() {
	if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') ) return;
	echo '<script type="text/javascript" src="'.IMAGEPASTE_URL.'js/'.IMAGEPASTE_JSDIR.'jquery.paste_image_reader.js" ></script>';
}

function imagepaste_init() {
	if (is_admin()) wp_enqueue_script('jquery');
}

function imagepaste_addbuttons() {
	// Don't bother doing this stuff if the current user lacks permissions
	if ( ! current_user_can('edit_posts') && ! current_user_can('edit_pages') )
	return;

	// Add only in Rich Editor mode
	if ( get_user_option('rich_editing') == 'true') {
		add_filter("mce_external_plugins", "add_imagepaste_tinymce_plugin");
		add_filter('mce_buttons', 'register_imagepaste_button');
	}
}
function register_imagepaste_button($buttons) {
	array_push($buttons, "separator", "tinyimagepaste");
	return $buttons;
}
// Load the TinyMCE plugin : editor_plugin.js (wp2.5)
function add_imagepaste_tinymce_plugin($plugin_array) {
	$plugin_array['tinyimagepaste'] = plugins_url().'/'.IMAGEPASTE_PLUGIN.'/tinymce/'.IMAGEPASTE_JSDIR.'editor_plugin.js';
	return $plugin_array;
}
// init process for button control
add_action('init', 'imagepaste_addbuttons');
add_action('wp_ajax_imagepaste_action', 'imagepaste_action_callback');

function imagepaste_action_callback() {
	$result=array('error'=>'');
	$upload = wp_upload_dir();
	$uploadUrl=$upload['url'];
	$uploadDir=$upload['path'];

	list($data,$image)=explode(';',$_REQUEST['dataurl']);
	list($field,$type)=explode(':',$data);
	list($encoding,$content)=explode(',',$image);
	if ($type=='image/png') $extension='png';

	$name=md5($_REQUEST['dataurl']);
	if (!$extension) {
		$result['error']="无法确定图像扩展类型";
	} else {
		$file=$uploadDir.'/'.$name.'.'.$extension;
		$fileUrl=$uploadUrl.'/'.$name.'.'.$extension;
		file_put_contents($file,base64_decode($content));
		if (defined('W3TC')) {
			$result['w3tc']=1;
			ob_start();
			$w3tc=new ImagepasteW3tc();
			//$result['w3tcconfig']=$w3tc->config;
			if ($w3tc->engine=='rscf') $w3tc->upload($uploadDir,$uploadUrl,$name.'.'.$extension);
			$result['log']=$w3tc->log;
			$result['output']=ob_get_clean();
		} else $result['w3tc']=0;

		$result['url']=$fileUrl;
		$result['elementid']=$_REQUEST['elementid'];
	}
	echo json_encode($result);
	die(); // this is required to return a proper result
}
